#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

long long subMat(vector<vector<int>> mat, int y, int x, int K, int L) {
	long long res = 0;
	for (int i = y; i < y + K; i++) {
		for (int j = x; j < x + L; j++) {
			res += mat[i][j];
		}
	}
	return res;
}

vector<vector<int>> brojObilazaka(int N, int M, int K, int L) {
	vector<vector<int>> mat(N);
	for (int i = 0; i < N; i++) {
		for (int j = 0; j < M; j++) {
			mat[i].push_back(0);
		}
	}
	for (int i = 0; i < N - K + 1; i++) {
		for (int j = 0; j < M - L + 1; j++) {
			for (int k = i; k < i + K; k++) {
				for (int r = j; r < j + L; r++) {
					mat[k][r] ++;
				}
			}
		}
	}
	return mat;
}

bool poredi(int a, int b) {
	return a > b;
}

int main()
{
	int N, M, K, L;
	cin >> N >> M >> K >> L;
	vector<int> brojevi(N * M);
	for (int i = 0; i < N * M; i++) {
		cin >> brojevi[i];
	}
	sort(brojevi.begin(), brojevi.end(), poredi);

	vector<vector<int>> mat = brojObilazaka(N,M,K,L);
	vector<vector<int>> mat1(N);
	for (int i = 0; i < N; i++) {
		for (int j = 0; j < M; j++) {
			mat1[i].push_back(0);
		}
	}

	for (int i = 0; i < N * M; i++) {
		int i_max = 0;
		int j_max = 0;
		for (int y = 0; y < N; y++) {
			for (int x = 0; x < M; x++) {
				if (mat[y][x] > mat[i_max][j_max]) {
					i_max = y;
					j_max = x;
				}
			}
		}
		mat1[i_max][j_max] = brojevi[i];
		mat[i_max][j_max] = -1;
	}
	
	long long suma = 0;

	for (int i = 0; i < N - K + 1; i++) {
		for (int j = 0; j < M - L + 1; j++) {
			suma += subMat(mat1, i, j, K, L);
		}
	}

	cout << suma;
}